/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.javax.swing;

import acm.util.ErrorException;
import acmx.export.javax.swing.CursorBlinker;
import acmx.export.javax.swing.text.AttributeSet;
import acmx.export.javax.swing.text.DefaultStyledDocument;
import acmx.export.javax.swing.text.Document;
import acmx.export.javax.swing.text.Element;
import acmx.export.javax.swing.text.SimpleAttributeSet;
import acmx.export.javax.swing.text.StyleConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;

public class JTextPane
extends Component
implements MouseListener,
MouseMotionListener,
FocusListener,
ComponentListener,
ClipboardOwner,
AdjustmentListener {
    private static final int TEXT_MARGIN = 5;
    private static Clipboard clipboard = null;
    private DefaultStyledDocument document = new DefaultStyledDocument();
    private SimpleAttributeSet dummyStyle = new SimpleAttributeSet();
    private CursorBlinker cb;
    private int canvasWidth;
    private int canvasHeight;
    private int fontAscent;
    private int fontHeight;
    private int maxLineLength;
    private int mousePressedDot;
    private Scrollbar vScrollbar;
    private Scrollbar hScrollbar;
    private boolean hasFocus;
    private boolean cursorState;

    public JTextPane() {
        this.document.setPane(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addComponentListener(this);
        this.addFocusListener(this);
    }

    public Document getDocument() {
        return this.document;
    }

    protected void setHScrollbar(Scrollbar hbar) {
        this.hScrollbar = hbar;
        this.hScrollbar.addAdjustmentListener(this);
    }

    protected void setVScrollbar(Scrollbar vbar) {
        this.vScrollbar = vbar;
        this.vScrollbar.addAdjustmentListener(this);
    }

    public void setText(String text) {
        if (text.length() != 0) {
            throw new ErrorException("Unsupported call to setText");
        }
        this.document.clear();
    }

    public void paint(Graphics g) {
        int x = 5 - this.hScrollbar.getValue();
        int y = 5 + this.fontAscent - this.vScrollbar.getValue();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.canvasWidth, this.canvasHeight);
        ArrayList elements = this.document.getElements();
        int nElements = elements.size();
        int dot = 0;
        int selectionStart = this.document.getSelectionStart();
        int selectionEnd = this.document.getSelectionEnd();
        int i = 0;
        while (i < nElements && y <= this.canvasHeight + this.fontAscent) {
            Element element = (Element)elements.get(i);
            String str = element.getString();
            if (str.equals("\n")) {
                if (++dot > selectionStart && dot < selectionEnd) {
                    g.setColor(SystemColor.textHighlight);
                    g.fillRect(x, y - 1, this.canvasWidth - x, this.fontHeight);
                }
                y += this.fontHeight;
                x = 5 - this.hScrollbar.getValue();
            } else {
                g.setColor(this.getColorFromStyle(element.getAttributes()));
                g.setFont(this.getFontFromStyle(element.getAttributes()));
                x = (int)((double)x + this.drawString(g, str, x, y, dot, y > -this.fontHeight));
                if (x > this.maxLineLength) {
                    this.maxLineLength = x;
                    this.updateScrollbars();
                }
                dot += str.length();
            }
            ++i;
        }
    }

    protected int length() {
        return this.document.getLength();
    }

    public int getSelectionStart() {
        return this.document.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.document.getSelectionEnd();
    }

    public void setSelectionStart(int start) {
        this.document.setSelectionStart(start);
        this.update();
    }

    public void setSelectionEnd(int end) {
        this.document.setSelectionEnd(end);
        this.update();
    }

    public void select(int start, int end) {
        this.document.setSelectionStart(start);
        this.document.setSelectionEnd(end);
        this.update();
    }

    public void selectAll() {
        this.document.setSelectionStart(0);
        this.document.setSelectionEnd(this.length());
        this.update();
    }

    public void setCaretPosition(int pos) {
        this.select(pos, pos);
    }

    public int getCaretPosition() {
        return this.getSelectionEnd();
    }

    public String getText() {
        return this.document.getText();
    }

    public void copy() {
        int selectionEnd;
        int selectionStart;
        if (clipboard == null) {
            this.initClipboard();
        }
        if ((selectionStart = this.document.getSelectionStart()) == (selectionEnd = this.document.getSelectionEnd())) {
            this.getToolkit().beep();
        } else {
            try {
                String str = this.document.getText(selectionStart, selectionEnd - selectionStart);
                clipboard.setContents(new StringSelection(str), this);
            }
            catch (Exception ex) {
                this.getToolkit().beep();
            }
        }
    }

    public void paste() {
        Transferable selection;
        if (clipboard == null) {
            this.initClipboard();
        }
        if ((selection = clipboard.getContents(this)) == null) {
            this.getToolkit().beep();
        } else {
            try {
                int dot = this.document.getSelectionEnd();
                String str = (String)selection.getTransferData(DataFlavor.stringFlavor);
                this.document.insertString(dot, str, this.dummyStyle);
            }
            catch (Exception ex) {
                this.getToolkit().beep();
            }
        }
    }

    protected void update() {
        this.updateScrollbars();
        this.ensureCursorVisible();
        this.getParent().repaint();
    }

    protected void updateScrollbars() {
        int requiredWidth = this.maxLineLength + 10;
        int requiredHeight = (this.document.getLineCount() + 1) * this.fontHeight + 10;
        if (this.hScrollbar.getMaximum() != requiredWidth) {
            this.hScrollbar.setMaximum(requiredWidth);
        }
        if (this.hScrollbar.getVisibleAmount() != this.canvasWidth) {
            this.hScrollbar.setVisibleAmount(this.canvasWidth);
        }
        if (this.vScrollbar.getMaximum() != requiredHeight) {
            this.vScrollbar.setMaximum(requiredHeight);
        }
        if (this.vScrollbar.getVisibleAmount() != this.canvasHeight) {
            this.vScrollbar.setVisibleAmount(this.canvasHeight);
        }
    }

    protected void ensureCursorVisible() {
        Rectangle r = this.modelToView(this.getCaretPosition());
        int minX = this.hScrollbar.getValue();
        int maxX = minX + this.canvasWidth;
        int minY = this.vScrollbar.getValue();
        int maxY = minY + this.canvasHeight;
        if (r.x < minX || r.x + r.width > maxX || r.y < minY || r.y + r.height > maxY) {
            this.hScrollbar.setValue(Math.max(0, r.x - this.canvasWidth / 2));
            this.vScrollbar.setValue(Math.max(0, r.y + r.height - this.canvasHeight / 2));
        }
    }

    public Rectangle modelToView(int pos) {
        ArrayList elements = this.document.getElements();
        int dot = 0;
        int cy = 5;
        int cx = 5;
        int nElements = elements.size();
        int i = 0;
        while (i < nElements && dot < pos) {
            Element element = (Element)elements.get(i);
            String str = element.getString();
            if (str.equals("\n")) {
                ++dot;
                cy += this.fontHeight;
                cx = 5;
            } else {
                dot += str.length();
                FontMetrics fm = this.getFontMetrics(this.getFontFromStyle(element.getAttributes()));
                cx += fm.stringWidth(element.getString());
            }
            ++i;
        }
        return new Rectangle(cx, cy, 1, this.fontHeight);
    }

    protected void toggleCursor() {
        this.cursorState = !this.cursorState;
        int selectionStart = this.document.getSelectionStart();
        int selectionEnd = this.document.getSelectionEnd();
        if (this.hasFocus && selectionStart == selectionEnd) {
            Rectangle r = this.modelToView(selectionStart);
            Graphics g = this.getGraphics();
            r.translate(-this.hScrollbar.getValue(), -this.vScrollbar.getValue());
            g.setColor(this.cursorState ? Color.BLACK : this.getBackground());
            g.drawLine(r.x - 1, r.y - 1, r.x - 1, r.y + this.fontHeight);
        }
    }

    public final void adjustmentValueChanged(AdjustmentEvent e) {
        this.getParent().repaint();
    }

    public final void focusGained(FocusEvent e) {
        this.hasFocus = true;
        this.cursorState = true;
        this.toggleCursor();
    }

    public final void focusLost(FocusEvent e) {
        this.hasFocus = false;
        this.update();
    }

    public final void mousePressed(MouseEvent e) {
        this.requestFocus();
        this.mousePressedDot = this.findCharacterPosition(e.getX(), e.getY());
        this.select(this.mousePressedDot, this.mousePressedDot);
    }

    public final void mouseClicked(MouseEvent e) {
    }

    public final void mouseReleased(MouseEvent e) {
    }

    public final void mouseEntered(MouseEvent e) {
    }

    public final void mouseExited(MouseEvent e) {
    }

    public final void mouseDragged(MouseEvent e) {
        int dot = this.findCharacterPosition(e.getX(), e.getY());
        this.setSelectionStart(Math.min(dot, this.mousePressedDot));
        this.setSelectionEnd(Math.max(dot, this.mousePressedDot));
        this.getParent().repaint();
    }

    public final void mouseMoved(MouseEvent e) {
    }

    public final void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public final void componentResized(ComponentEvent e) {
        this.computeCanvasParameters();
        if (this.cb == null) {
            try {
                this.cb = new CursorBlinker(this);
                Thread t = new Thread(this.cb);
                t.setDaemon(true);
                t.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void componentHidden(ComponentEvent e) {
    }

    public final void componentMoved(ComponentEvent e) {
    }

    public final void componentShown(ComponentEvent e) {
    }

    private void computeCanvasParameters() {
        Dimension size = this.getSize();
        this.canvasWidth = size.width;
        this.canvasHeight = size.height;
        Font font = this.getFont();
        FontMetrics fm = this.getFontMetrics(font);
        this.fontHeight = fm.getHeight();
        this.fontAscent = fm.getAscent();
        int emSpace = fm.stringWidth("m");
        this.hScrollbar.setUnitIncrement(emSpace);
        this.hScrollbar.setBlockIncrement(this.canvasWidth - emSpace);
        this.vScrollbar.setUnitIncrement(this.fontHeight);
        this.vScrollbar.setBlockIncrement(this.canvasHeight - this.fontHeight);
    }

    private double drawString(Graphics g, String str, int x, int y, int dot, boolean visible) {
        FontMetrics fm = g.getFontMetrics();
        if (visible) {
            int lastSelected;
            int firstSelected = Math.min(str.length(), Math.max(0, this.document.getSelectionStart() - dot));
            if (firstSelected < (lastSelected = Math.min(str.length(), Math.max(0, this.document.getSelectionEnd() - dot)))) {
                Color color = g.getColor();
                int x0 = x + fm.stringWidth(str.substring(0, firstSelected));
                int x1 = x + fm.stringWidth(str.substring(0, lastSelected));
                int y0 = y - this.fontAscent - 1;
                g.setColor(SystemColor.textHighlight);
                g.fillRect(x0, y0, x1 - x0, this.fontHeight);
                g.setColor(color);
            }
            g.drawString(str, x, y);
        }
        return fm.stringWidth(str);
    }

    private Color getColorFromStyle(AttributeSet style) {
        Color color = (Color)style.getAttribute(StyleConstants.Foreground);
        if (color == null) {
            color = this.getForeground();
        }
        return color;
    }

    private Font getFontFromStyle(AttributeSet style) {
        boolean italic;
        boolean bold;
        int fontStyle;
        Font font = this.getFont();
        if (!style.isEmpty() && (fontStyle = ((bold = ((Boolean)style.getAttribute(StyleConstants.Bold)).booleanValue()) ? 1 : 0) + ((italic = ((Boolean)style.getAttribute(StyleConstants.Italic)).booleanValue()) ? 2 : 0)) != font.getStyle()) {
            font = new Font(font.getFamily(), fontStyle, font.getSize());
        }
        return font;
    }

    private int findCharacterPosition(int x, int y) {
        int x0 = x + this.hScrollbar.getValue();
        int y0 = y + this.vScrollbar.getValue();
        if (y0 < 5) {
            return 0;
        }
        ArrayList elements = this.document.getElements();
        int nElements = elements.size();
        int dot = 0;
        int cy = 5 + this.fontHeight;
        int cx = 5;
        int i = 0;
        while (i < nElements && (cy < y0 || cx < x0)) {
            Element element = (Element)elements.get(i);
            String str = element.getString();
            if (str.equals("\n")) {
                ++dot;
                cy += this.fontHeight;
            } else {
                if (cy >= y0) {
                    FontMetrics fm = this.getFontMetrics(this.getFontFromStyle(element.getAttributes()));
                    int nx = cx + fm.stringWidth(str);
                    if (nx >= x0) {
                        int minDelta = Math.abs(nx - x0);
                        int minPos = str.length();
                        int cp = 0;
                        while (cp < str.length()) {
                            nx = cx + fm.stringWidth(str.substring(0, cp));
                            int delta = Math.abs(nx - x0);
                            if (delta < minDelta) {
                                minDelta = delta;
                                minPos = cp;
                            }
                            ++cp;
                        }
                        this.document.findOffsetPosition(dot + minPos);
                        return dot + minPos;
                    }
                    cx = nx;
                }
                dot += str.length();
            }
            ++i;
        }
        return dot;
    }

    private void initClipboard() {
        if (clipboard != null) {
            return;
        }
        try {
            clipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception ex) {
            clipboard = new Clipboard("LocalClipboard");
        }
    }
}

